﻿'版权所有 (C) Microsoft Corporation。保留所有权利。

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Linq

Public Class Samples
    Shared numbers As Integer() = New Integer() {5, 4, 1, 3, 9, 8, 6, 7, 2, 0}
    Shared strings As String() = New String() {"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"}

    Class Person
        Public Name As String
        Public Level As String
    End Class

    Shared persons As Person() = New Person() { _
        New Person With {.Name = "Jesper", .Level = 3}, _
        New Person With {.Name = "Lene", .Level = 3}, _
        New Person With {.Name = "Jonathan", .Level = 5}, _
        New Person With {.Name = "Sagiv", .Level = 3}, _
        New Person With {.Name = "Jacqueline", .Level = 3}, _
        New Person With {.Name = "Ellen", .Level = 3}, _
        New Person With {.Name = "Gustavo", .Level = 9}}


    Public Shared Sub Sample1()
        ' 使用 Where() 筛选出符合特定条件的元素       
        Dim fnums = numbers.Where(Function(n) n < 5)

        Console.WriteLine("Numbers < 5")
        For Each x As Integer In fnums
            Console.WriteLine(x)
        Next
    End Sub

    Public Shared Sub Sample2()
        ' 使用 First() 查找一个符合特定条件的元素       
        Dim v As String = strings.First(Function(s) s(0) = "o"c)

        Console.WriteLine("string starting with 'o': {0}", v)
    End Sub

    Public Shared Sub Sample3()
        ' 使用 Select() 将每个元素都转换为新值
        Dim snums = numbers.Select(Function(n) strings(n))

        Console.WriteLine("Numbers")
        For Each s As String In snums
            Console.WriteLine(s)
        Next
    End Sub

    Public Shared Sub Sample4()
        ' 使用匿名类型构造函数即时构造多值结果
        Dim q = strings.Select(Function(s) New With {.Head = s.Substring(0, 1), .Tail = s.Substring(1)})
        For Each p In q
            Console.WriteLine("Head = {0}, Tail = {1}", p.Head, p.Tail)
        Next
    End Sub

    Public Shared Sub Sample5()
        ' 结合使用 Select() 与 Where()，以进行完整的查询
        Dim q = numbers.Where(Function(n) n < 5).Select(Function(n) strings(n))

        Console.WriteLine("Numbers < 5")
        For Each x In q
            Console.WriteLine(x)
        Next
    End Sub

    Public Shared Sub Sample6()
        ' 使用 GroupBy() 将相似元素分组以构造组分区
        Dim q = strings.GroupBy(Function(s) s(0)) ' <- 按每个字符串的第一个字符分组

        For Each g In q
            Console.WriteLine("Group: {0}", g.Key)
            For Each v As String In g
                Console.WriteLine(vbTab & "Value: {0}", v)
            Next
        Next
    End Sub

    Public Shared Sub Sample7()
        ' 使用 GroupBy() 和诸如 Count()、Min()、Max()、Sum()、Average() 等聚合函数来对分区计算值
        Dim q = strings.GroupBy(Function(s) s(0)).Select(Function(g) New With {.FirstChar = g.Key, .Count = g.Count()})

        For Each v In q
            Console.WriteLine("There are {0} string(s) starting with the letter {1}", v.Count, v.FirstChar)
        Next
    End Sub

    Public Shared Sub Sample8()
        ' 使用 OrderBy()/OrderByDescending() 对所生成的序列进行排序
        Dim q = strings.OrderBy(Function(s) s) ' 按字符串的名称对字符串进行排序

        For Each s As String In q
            Console.WriteLine(s)
        Next
    End Sub

    Public Shared Sub Sample9()
        ' 使用 ThenBy()/ThenByDescending() 提供其他排序详细信息
        Dim q = persons.OrderBy(Function(p) p.Level).ThenBy(Function(p) p.Name)

        For Each p In q
            Console.WriteLine("{0}  {1}", p.Level, p.Name)
        Next
    End Sub

    Public Shared Sub Sample10()
        ' 使用查询表达式进行简化
        Dim q = From p In persons _
                Order By p.Level, p.Name _
                Group p.Name By p.Level Into People = Group

        For Each g In q
            Console.WriteLine("Level: {0}", g.Level)
            For Each s In g.People
                Console.WriteLine("Person: {0}", s)
            Next
        Next
    End Sub
End Class
